//
//  MCCDiscoveryHelper.h
//  MCCloud
//
//  Created by Thomas Bartelmess on 11.02.10.
//  Copyright 2010 Marketcircle. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCCDiscoveryHelperDelegate.h"

@class MCRestRequest;

@interface MCCDiscoveryHelper : NSObject {
	
	id <MCCDiscoveryHelperDelegate> delegate;
	NSString *cloudID;
	
	MCRestRequest *request;
}

@property (retain) id <MCCDiscoveryHelperDelegate> delegate;
@property (copy) NSString *cloudID;

- (void)discoverServerForService:(NSString *)serviceIdentifier
				  mccloudAccount:(NSString *)username
			 applicationUsername:(NSString *)applicationUsername 
			 applicationPassword:(NSString *)applicationPassword
					databaseName:(NSString *)databaseName
				   schemaVersion:(NSUInteger)schemaVersion;
@end
